<?php
/*
=====================================================
 DleTrack (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011 Alexander Ahminenko (PressFx)
=====================================================
     
-----------------------------------------------------
 E-Mail: a.ahminenko@gmail.com | ICQ: 68-12-16
=====================================================
*/
@session_start( );
@error_reporting( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set( 'display_errors', true );
@ini_set( 'html_errors', false );
@ini_set( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', '../../../..' );
define( 'ENGINE_DIR', ROOT_DIR . '/engine' );

include_once ENGINE_DIR . '/data/config.php';
include_once ENGINE_DIR . '/data/dlemovie.php';
include_once ENGINE_DIR . '/classes/mysql.php';
include_once ENGINE_DIR . '/data/dbconfig.php';
include_once ENGINE_DIR . '/modules/functions.php';
include_once ENGINE_DIR . '/classes/parse.class.php';

include_once ROOT_DIR . '/language/' . $config['langs'] . '/website.lng';
$config['charset'] = ( $lang['charset'] != '' ) ? $lang['charset'] : $config['charset'];
include_once ENGINE_DIR . '/modules/sitelogin.php';

$user_group = get_vars( "usergroup" );
if ( ! $user_group ) {
    $user_group = array( );
    $db->query( "SELECT * FROM " . USERPREFIX . "_usergroups ORDER BY id ASC" );
    while ( $row = $db->get_row() ) {
        $user_group[$row['id']] = array( );
        foreach ( $row as $key => $value ) {
            $user_group[$row['id']][$key] = stripslashes($value);
        }
    }
    set_vars( "usergroup", $user_group );
    $db->free( );
}

$parse = new ParseFilter( );
$parse->safe_mode = true;
$parse->allow_url = $user_group[$member_id['user_group']]['allow_url'];
$parse->allow_image = $user_group[$member_id['user_group']]['allow_image'];

$_TIME = time( ) + ( $config['date_adjust'] * 60 );
$id = intval( $_REQUEST['id'] );
if ( ! $id or ! $is_logged ) die( 'error' );

if ( $_REQUEST['action'] == 'edit' ) {
    $row = $db->super_query( "SELECT * FROM " . PREFIX . "_dm_comments WHERE id = '$id'" );
    $have_perm = 0;
    if ( ! $row ) die( 'error' );
    if ( $is_logged and ( ( $member_id['name'] == $row['autor'] and $row['is_register'] and $user_group[$member_id['user_group']]['allow_editc'] ) or $user_group[$member_id['user_group']]['edit_allc'] ) ) $have_perm = 1;
    elseif ( $user_group[$member_id['user_group']]['edit_limit'] AND ( ( $row['date'] + ( $user_group[$member_id['user_group']]['edit_limit'] * 60 ) ) < $_TIME ) ) $have_perm = 0;
    if ( ! $have_perm ) die( 'error' );
    if ( $config['allow_comments_wysiwyg'] != "yes" ) {
        include_once ENGINE_DIR . '/ajax/bbcode.php';
        $comm_txt = $parse->decodeBBCodes( $row['text'], false );
    } else {
        $comm_txt = $parse->decodeBBCodes( $row['text'], true, "yes" );
        if ( $user_group[$member_id['user_group']]['allow_url'] ) $link_icon = "link,dle_leech,separator,"; else $link_icon = "";
        if ( $user_group[$member_id['user_group']]['allow_image'] ) $link_icon .= "image,";
        $bb_code = "
        <script type=\"text/javascript\">
            \$('#dleeditcomments{$id}').tinymce({
                script_url : '{$config['http_home_url']}engine/editor/jscripts/tiny_mce/tiny_mce.js',
                theme : \"advanced\",
                skin : \"cirkuit\",
                language : \"{$lang['wysiwyg_language']}\",
                width : \"99%\",
                height : \"220\",
                plugins : \"safari,emotions,inlinepopups\",
                convert_urls : false,
                force_p_newlines : false,
                force_br_newlines : true,
                dialog_type : 'window',
                extended_valid_elements : \"div[align|class|style|id|title]\",
                theme_advanced_buttons1 : \"bold,italic,underline,separator,strikethrough,justifyleft,justifycenter,justifyright, justifyfull,bullist,numlist,separator,{$link_icon}emotions,dle_quote,dle_hide\",
                theme_advanced_buttons2 : \"\",
                theme_advanced_buttons3 : \"\",
                theme_advanced_toolbar_location : \"top\",
                theme_advanced_toolbar_align : \"left\",
                theme_advanced_statusbar_location : \"bottom\",
                content_css : \"{$config['http_home_url']}engine/editor/css/content.css\",
                setup : function(ed) {
                    ed.addButton('dle_quote', {
                    title : '{$lang['bb_t_quote']}',
                    image : '{$config['http_home_url']}engine/editor/jscripts/tiny_mce/themes/advanced/img/dle_quote.gif',
                    onclick : function() { ed.execCommand('mceReplaceContent',false,'[quote]{\$selection}[/quote]'); }
                    });
                    ed.addButton('dle_hide', {
                    title : '{$lang['bb_t_hide']}',
                    image : '{$config['http_home_url']}engine/editor/jscripts/tiny_mce/themes/advanced/img/dle_hide.gif',
                    onclick : function() { ed.execCommand('mceReplaceContent',false,'[hide]{\$selection}[/hide]'); }
                    });
                    ed.addButton('dle_leech', {
                    title : '{$lang['bb_t_leech']}',
                    image : '{$config['http_home_url']}engine/editor/jscripts/tiny_mce/themes/advanced/img/dle_leech.gif',
                    onclick : function() { ed.execCommand('mceReplaceContent',false,\"[leech=http://]{\$selection}[/leech]\"); }
                    });
                }
            });
        </script>";
    }
    $buffer = "
    <div class=\"editor\">{$bb_code}
    <textarea name=\"dleeditcomments{$id}\" id=\"dleeditcomments{$id}\" onclick=\"setNewField(this.name, document.getElementById( 'dlemasscomments' ) )\" style=\"width:99%;height:150px;border:1px solid #E0E0E0;margin: 0px 1px 0px 0px;padding: 0px;\">{$comm_txt}</textarea><br>
    <div align=\"right\" style=\"width:99%;padding-top:5px;\"><input class=bbcodes title=\"$lang[bb_t_apply]\" type=button onclick=\"DleMovieCommentEditSave('{$id}');return false;\" value=\"$lang[bb_b_apply]\" />
    <input class=bbcodes title=\"$lang[bb_t_cancel]\" type=button onclick=\"ajax_cancel_comm_edit('{$id}');return false;\" value=\"$lang[bb_b_cancel]\" /></div></div>";
} elseif ( $_REQUEST['action'] == 'save' ) {
    $row = $db->super_query( "SELECT * FROM " . PREFIX . "_dm_comments WHERE id = '$id'" );
    $have_perm = 0;
    if ( ! $row ) die( 'error' );
    if ( $is_logged and ( ( $member_id['name'] == $row['autor'] and $row['is_register'] and $user_group[$member_id['user_group']]['allow_editc'] ) or $user_group[$member_id['user_group']]['edit_allc'] ) ) $have_perm = 1;
    elseif ( $user_group[$member_id['user_group']]['edit_limit'] AND ( ( $row['date'] + ( $user_group[$member_id['user_group']]['edit_limit'] * 60 ) ) < $_TIME ) ) $have_perm = 0;
    if ( ! $have_perm ) die( 'error' );
    if ( $config['allow_comments_wysiwyg'] == "yes" ) {
        $parse->wysiwyg = true;
        $use_html = true;
        $parse->ParseFilter( Array( 'div', 'span', 'p', 'br', 'strong', 'em', 'ul', 'li', 'ol' ), Array( ), 0, 1 );
        if ( $user_group[$member_id['user_group']]['allow_url'] ) $parse->tagsArray[] = 'a';
        if ( $user_group[$member_id['user_group']]['allow_image'] ) $parse->tagsArray[] = 'img';
    } else $use_html = false;
    $comm_txt = trim( $parse->BB_Parse( $parse->process( convert_unicode( $_POST['comm_txt'], $config['charset'] ) ), $use_html ) );
    if ( $parse->not_allowed_tags ) die( "error" );
    if ( $parse->not_allowed_text ) die( "error" );
    if ( dle_strlen( $comm_txt, $config['charset'] ) > $config['comments_maxlen'] ) die( "error" );
    if ( $comm_txt == "" ) die( "error" );
    if ( intval( $dlemovie_config['comments_minsize'] ) AND dle_strlen( $comm_txt, $config['charset'] ) < $dlemovie_config['comments_minsize'] ) die( "error" );
    if ( intval( $config['auto_wrap'] ) ) {
        $comm_txt = preg_split( '((>)|(<))', $comm_txt, - 1, PREG_SPLIT_DELIM_CAPTURE );
        $n = count( $comm_txt );
        for ( $i = 0; $i < $n; $i ++ ) {
            if ( $comm_txt[$i] == "<" ) {
                $i ++;
                continue;
            }
            $comm_txt[$i] = preg_replace( "#([^\s\n\r]{" . intval( $config['auto_wrap'] ) . "})#i", "\\1<br />", $comm_txt[$i] );
        }
        $comm_txt = join( "", $comm_txt );
    }
    $comm_update = $db->safesql( $comm_txt );
    $db->query( "UPDATE " . PREFIX . "_dm_comments SET text = '$comm_update' WHERE id = '$id'" );
    $comm_txt = str_replace( "[hide]", "", str_replace( "[/hide]", "", $comm_txt ) );
    $buffer = str_replace( '{THEME}', $config['http_home_url'] . 'templates/' . $config['skin'], stripslashes( $comm_txt ) );
} else die( 'error' );

$db->close( );

@header( "Content-type: text/html; charset=" . $config['charset'] );
echo $buffer;
?>